/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.tool.function.SerializableThrowingFunction;
import org.codefilarete.tool.function.SerializableThrowingTriConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class PreparedStatementWriterTest {
    PreparedStatementWriterTest() {
    }

    @Test
    void preApply_typeIsConverterOne() {
        PreparedStatementWriter<Long> preparedStatementWriter = new PreparedStatementWriter<Long>(){

            public Class<Long> getType() {
                return Long.TYPE;
            }

            public void set(PreparedStatement preparedStatement, int valueIndex, Long value) {
            }
        };
        Assertions.assertThat((Class)preparedStatementWriter.getType()).isEqualTo(Long.TYPE);
        PreparedStatementWriter testInstance1 = preparedStatementWriter.preApply(Date::getTime);
        Assertions.assertThat((Class)testInstance1.getType()).isEqualTo(Date.class);
        PreparedStatementWriter testInstance2 = preparedStatementWriter.preApply(PreparedStatementWriterTest::getTimeAsStatic);
        Assertions.assertThat((Class)testInstance2.getType()).isEqualTo(Date.class);
        PreparedStatementWriter testInstance3 = preparedStatementWriter.preApply(this::getTimeAsNonStatic);
        Assertions.assertThat((Class)testInstance3.getType()).isEqualTo(Date.class);
        PreparedStatementWriter testInstance4 = preparedStatementWriter.preApply((SerializableThrowingFunction & Serializable)date -> {
            String s = "Hello world".toUpperCase();
            String string = s.toLowerCase();
            return date.getTime();
        });
        Assertions.assertThat((Class)testInstance4.getType()).isEqualTo(Date.class);
    }

    static Stream<Arguments> ofMethodReference() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{PreparedStatement::setLong, Long.TYPE}), Arguments.arguments((Object[])new Object[]{PreparedStatement::setDate, java.sql.Date.class}), Arguments.arguments((Object[])new Object[]{PreparedStatement::setDouble, Double.TYPE}), Arguments.arguments((Object[])new Object[]{PreparedStatement::setFloat, Float.TYPE}), Arguments.arguments((Object[])new Object[]{PreparedStatement::setString, String.class}));
    }

    @ParameterizedTest
    @MethodSource
    <O> void ofMethodReference(SerializableThrowingTriConsumer<PreparedStatement, Integer, O, SQLException> preparedStatementSetter, Class<O> expectedType) {
        Assertions.assertThat((Class)PreparedStatementWriter.ofMethodReference(preparedStatementSetter).getType()).isEqualTo(expectedType);
    }

    public static long getTimeAsStatic(Date date) {
        return date.getTime();
    }

    public long getTimeAsNonStatic(Date date) {
        return date.getTime();
    }
}

